<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('User_courses', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Enrollment_id');
            $table->unsignedBigInteger('User_id');
            $table->unsignedBigInteger('Course_id');
            $table->decimal('Progress', 5, 2)->default(0.00);
            $table->timestamp('Completed_at')->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->foreign('Course_id')->references('Course_id')->on('Courses')->onDelete('cascade');
            $table->index(['User_id', 'Course_id'], 'Idx_user_course');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('User_courses');
    }
};
